<?php

defined('ABSPATH') || exit;

$meta = Ucore()->get( 'ulz_custom_icon_set', get_the_ID() );
$has_icons = isset( $meta['icons'] ) && ! empty( $meta['icons'] ) && is_array( $meta['icons'] );
$post_status = get_post_status();

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">

        <div class="ulz-upload-inline <?php if( $has_icons ) { echo 'ulz-none'; } ?>">

            <label class="ulz--label ulz-none" for="icon-package"></label>
            <input type="file" id="icon-package" name="icon-package" class="ulz-none ulz--file"
                accept="zip,application/zip,application/x-zip,application/x-zip-compressed,application/zip-compressed,application/easykaraoke.cdgdownload">

            <div class="upload-cover-drag">
                <div class="ulz--inner">

                    <?php if( $post_status !== 'publish' ): ?>
                        <div class="ulz--icon">
                            <i class="fas fa-save"></i>
                        </div>
                        <div class="ulz--content">
                            <p><strong><?php esc_html_e( 'Name and publish the post, then upload your font package', 'utillz-core' ); ?></strong></p>
                        </div>
                    <?php else: ?>
                        <div class="ulz--icon">
                            <i class="fas fa-upload"></i>
                        </div>
                        <div class="ulz--content">
                            <p><strong><?php echo sprintf( esc_html__( 'Upload your icon package generated by the %s', 'utillz-core' ), '<a href="https://icomoon.io/app/" target="_blank">' . esc_html__('Icomoon App', 'utillz-core') . '</a>' ); ?></strong></p>
                        </div>
                        <div class="ulz--upload">
                            <div class="ulz--button">
                                <a href="#" class="ulz-button">
                                    <span><?php esc_html_e( 'Select icon package', 'utillz-core' ); ?></span>
                                    <?php Ucore()->preloader() ?>
                                </a>
                            </div>
                            <div class="ulz--name">
                                <div class="ulz-form-group">
                                    <input type="text" name="icon-package-name" value="" disabled>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="upload-thumbs">
                <ul>
                    <li>
                        <span class="upload-background"><a href="#" class="upload-remove"><i class="icon icon-close-circle-bold"></i></a></span>
                        <i class="icon icon-image"></i>
                    </li>
                    <li>
                        <span class="upload-background"><a href="#" class="upload-remove"><i class="icon icon-close-circle-bold"></i></a></span>
                        <i class="icon icon-image"></i>
                    </li>
                    <li>
                        <span class="upload-background"><a href="#" class="upload-remove"><i class="icon icon-close-circle-bold"></i></a></span>
                        <i class="icon icon-image"></i>
                    </li>
                    <li>
                        <span class="upload-background"><a href="#" class="upload-remove"><i class="icon icon-close-circle-bold"></i></a></span>
                        <i class="icon icon-image"></i>
                    </li>
                    <li>
                        <span class="upload-background"><a href="#" class="upload-remove"><i class="icon icon-close-circle-bold"></i></a></span>
                        <i class="icon icon-image"></i>
                    </li>
                </ul>
            </div>
        </div>

        <?php if( $has_icons ): ?>
            <div class="ulz-icons-inline">
                <p class="">
                    <a href="#" class="ulz-button ulz--small" data-action="re-upload-set"><?php esc_html_e( 'Re-upload icon set', 'utillz-core' ); ?></a>
                </p>
                <table class="ulz-table ulz-mt-4 ulz-mb-4">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Package details', 'utillz-core' ); ?></th>
                            <th>&nbsp;</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php esc_html_e( 'Icons', 'utillz-core' ); ?></td>
                            <td><?php echo count( $meta['icons'] ); ?></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'Prefix', 'utillz-core' ); ?></td>
                            <td><?php echo esc_attr( $meta['prefix'] ); ?></td>
                        </tr>
                    </tbody>
                </table>
                <ul>
                    <?php foreach( $meta['icons'] as $key => $icon ): ?>
                        <li title="<?php echo esc_attr( $icon ); ?>"><i class="<?php echo esc_attr( $meta['prefix'] . ' ' . $meta['prefix'] . $icon ); ?>"></i></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

    </div>
</div>
